﻿Ext.apply(Ext.form.VTypes, {
    time: function (val, field) {
        return /[\d\s:amp]/i.test(val);
    },
    // vtype Text property: The error text to display when the validation function returns false
    timeText: 'Not a valid time.  Must be in the format "12:34 PM".',
    // vtype Mask property: The keystroke filter mask
    timeMask: /[\d\s:amp]/i,

    time2: function (val, field) {
        return /[\d:]/.test(val);
    },
    time2Text: 'Not a valid time.  Must be in the format "HH:mm".',
    time2Mask: /[\d:]/,

    alphaSpace: function (val, field) {
        return /^[a-z\s]+$/i.test(val);
    },
    alphaSpaceText: 'Not a valid value.',
    alphaSpaceMask: /[a-z\s]/i,

    alphanumSpace: function (val, field) {
        return /^[a-z0-9\s]+$/i.test(val);
    },
    alphanumSpaceText: 'Not a valid value.',
    alphanumSpaceMask: /[a-z0-9\s]/i,

    address: function (val, field) {
        return /^[a-z0-9\-\s]+$/i.test(val);
    },
    addressText: 'Not a valid address.',
    addressMask: /[a-z0-9\-\s]/i,

    postalCode: function (val, field) {
        return /^[0-9\-]+$/.test(val);
    },
    postalCodeText: 'Not a valid postal code.',
    postalCodeMask: /[0-9\-]/i,

    date: function (val, field) {
        return /^[0-9\/]+$/.test(val);
    },
    dateText: 'Not a valid date.',
    dateMask: /[0-9\/]/i,

    lnil4SSN: function (val, field) {
        return /[a-z]{1}[0-9]{4}/i.test(val);
    },
    lnil4SSNText: 'Not a valid Last Name initial and Last 4 SSN.',
    lnil4SSNMask: /[a-z]{1}[0-9]{4}/i,

    alphanumXSS: function (val, field) {
        var bTest1 = false,
            bTest2 = false,
            bRresult;

        bTest1 = /<[a-z?!\/]/i.test(val);
        bTest2 = /&#/i.test(val);

        bResult = !(bTest1 || bTest2);

        return bResult;
    },
    alphanumXSSText: 'Please review the highlighted field(s) for the following issues:<br/><ul>' +
                     '<li>The application will not accept a less-than symbol (<) followed by a letter. This can be corrected by adding a space between the symbol and the letter, e.g., "< score".</li>' +
                     '<li>The application will not accept an ampersand (&) followed by a hash sign (#). This can also be corrected by adding a space between the two symbols, i.e., "& #".</li></ul>'

});